"""update order schema

Revision ID: update_order_schema
Revises: initial_schema
Create Date: 2024-01-01 00:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy import text
import json

# revision identifiers, used by Alembic.
revision = 'update_order_schema'
down_revision = 'initial_schema'
branch_labels = None
depends_on = None

def upgrade():
    # Get connection and execute raw SQL
    connection = op.get_bind()
    
    # Migrate data from Text to JSON
    orders = connection.execute(
        text('SELECT id, items, blankets, order_details, addons, statement_colours, selected_colours FROM orders')
    ).fetchall()
    
    for order in orders:
        # Convert existing data to JSON strings
        items = json.dumps(json.loads(order[1]) if order[1] else [])
        blankets = json.dumps(json.loads(order[2]) if order[2] else [])
        order_details = json.dumps(json.loads(order[3]) if order[3] else {})
        addons = json.dumps(json.loads(order[4]) if order[4] else [])
        statement_colours = json.dumps(json.loads(order[5]) if order[5] else [])
        selected_colours = json.dumps(json.loads(order[6]) if order[6] else [])
        
        # Update the columns with JSON data
        connection.execute(
            text('UPDATE orders SET items = :items, blankets = :blankets, order_details = :order_details, addons = :addons, statement_colours = :statement_colours, selected_colours = :selected_colours WHERE id = :id'),
            {
                'items': items,
                'blankets': blankets,
                'order_details': order_details,
                'addons': addons,
                'statement_colours': statement_colours,
                'selected_colours': selected_colours,
                'id': order[0]
            }
        )
    
    # Add unique constraint to order_number using batch mode
    with op.batch_alter_table('orders') as batch_op:
        batch_op.create_unique_constraint('uq_orders_order_number', ['order_number'])

def downgrade():
    # Remove unique constraint using batch mode
    with op.batch_alter_table('orders') as batch_op:
        batch_op.drop_constraint('uq_orders_order_number', type_='unique') 