"""add order sequence

Revision ID: add_order_sequence
Revises: update_order_schema
Create Date: 2024-01-01 00:00:00.000000

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'add_order_sequence'
down_revision = 'update_order_schema'
branch_labels = None
depends_on = None

def upgrade():
    # Create order_sequence table
    op.create_table(
        'order_sequence',
        sa.Column('id', sa.Integer, primary_key=True),
        sa.Column('prefix', sa.String(10), nullable=False, unique=True),
        sa.Column('last_number', sa.Integer, nullable=False, default=99),
        sa.Column('created_at', sa.DateTime, server_default=sa.func.now()),
        sa.Column('updated_at', sa.DateTime, server_default=sa.func.now(), onupdate=sa.func.now())
    )
    
    # Insert initial sequences
    op.execute("INSERT INTO order_sequence (prefix, last_number) VALUES ('GH', 99)")  # Greenhawk
    op.execute("INSERT INTO order_sequence (prefix, last_number) VALUES ('I', 99)")   # Independent
    op.execute("INSERT INTO order_sequence (prefix, last_number) VALUES ('HC', 99)")  # Horsey Clean

def downgrade():
    op.drop_table('order_sequence') 