-- Create base add-ons table if it doesn't exist
CREATE TABLE IF NOT EXISTS base_add_ons (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    type VARCHAR(50) NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Drop existing base add-ons
DELETE FROM base_add_ons;

-- Insert standard add-ons with specific rules
INSERT INTO base_add_ons (name, type, price, description) VALUES
-- Water Treatment variations
('Water Treatment (Standard)', 'water_treatment', 19.00, 'Standard water treatment for regular blankets'),
('Water Treatment (Foal/Mini)', 'water_treatment', 12.00, 'Base rate for Foal/Mini blankets - price can be adjusted via slider'),
('Water Treatment (Dog Blanket/Bed)', 'water_treatment', 6.00, 'Base rate for Dog Blanket/Bed - price can be adjusted via slider'),
('Hood Water Treatment', 'water_treatment', 8.00, 'Additional water treatment for hoods'),

-- Hood variations
('Hood (Standard)', 'hood', 8.00, 'Standard hood for regular blankets'),
('Hood (Foal/Mini)', 'hood', 4.00, 'Hood for Foal/Mini blankets'),
('Hood (1/4 Sheet)', 'hood', 5.00, 'Hood for 1/4 Sheet blankets'),

-- Other add-ons
('Heavy Hair', 'heavy_hair', 8.00, 'Additional charge for heavy hair'),
('Heavy Soil', 'heavy_soil', 8.00, 'Additional charge for heavy soil'),
('Double Weight (1/4 Sheet)', 'double_weight', 2.50, 'Double weight option for 1/4 Sheet'),
('Repairs', 'repair', 36.00, 'Base price per hour for repairs (calculated in 5-minute increments with 15-minute minimum)');

-- Add indexes for better performance
CREATE INDEX idx_base_add_ons_type ON base_add_ons(type);
CREATE INDEX idx_base_add_ons_name ON base_add_ons(name); 