-- Disable foreign key checks
SET FOREIGN_KEY_CHECKS = 0;

-- Drop existing table if it exists
DROP TABLE IF EXISTS inventory_images;

-- Create inventory_images table
CREATE TABLE inventory_images (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    store_id VARCHAR(50) NOT NULL,
    customer_id INT,
    image_url VARCHAR(255) NOT NULL,
    bag_number VARCHAR(50),
    total_bags INT,
    notes TEXT,
    uploaded_by VARCHAR(100),
    upload_source ENUM('mobile', 'desktop', 'tablet') NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (order_id) REFERENCES orders(id),
    FOREIGN KEY (store_id) REFERENCES stores(id),
    FOREIGN KEY (customer_id) REFERENCES customers(id)
);

-- Create indexes for faster lookups
CREATE INDEX idx_inventory_images_order_id ON inventory_images(order_id);
CREATE INDEX idx_inventory_images_store_id ON inventory_images(store_id);
CREATE INDEX idx_inventory_images_customer_id ON inventory_images(customer_id);
CREATE INDEX idx_inventory_images_created_at ON inventory_images(created_at);

-- Create view for easy access to inventory images with order details
CREATE OR REPLACE VIEW order_inventory_images AS
SELECT 
    ii.id as image_id,
    ii.order_id,
    ii.store_id,
    ii.customer_id,
    ii.image_url,
    ii.bag_number,
    ii.total_bags,
    ii.notes,
    ii.uploaded_by,
    ii.upload_source,
    ii.created_at,
    o.order_number,
    o.date as order_date,
    c.name as customer_name,
    c.type as customer_type,
    s.name as store_name,
    s.type as store_type
FROM inventory_images ii
JOIN orders o ON ii.order_id = o.id
LEFT JOIN customers c ON ii.customer_id = c.id
JOIN stores s ON ii.store_id = s.id;

-- Re-enable foreign key checks
SET FOREIGN_KEY_CHECKS = 1; 