from fastapi import APIRouter, Depends, Query
from sqlalchemy.orm import Session
from ..database import get_db
from ..models.customer import Customer  # adjust if you use a different import path
from typing import List

router = APIRouter(prefix="/customers", tags=["customers"])

@router.get("/search", response_model=List[dict])
def search_customers(
    q: str = Query(..., description="Search by name, email, or phone"),
    db: Session = Depends(get_db)
):
    results = (
        db.query(Customer)
        .filter(
            (Customer.name.ilike(f"%{q}%")) |
            (Customer.email.ilike(f"%{q}%")) |
            (Customer.phone.ilike(f"%{q}%"))
        )
        .limit(10)
        .all()
    )
    return [
        {
            "id": c.id,
            "name": c.name,
            "email": c.email,
            "phone": c.phone,
            "address": c.address
        }
        for c in results
    ]
