# store_customer.py
from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.orm import relationship
from .base import Base

class StoreCustomer(Base):
    __tablename__ = "store_customers"

    id = Column(Integer, primary_key=True)
    name = Column(String, nullable=False)
    email = Column(String)
    phone = Column(String)
    store_id = Column(Integer, ForeignKey("stores.id"))

    store = relationship("Store", back_populates="customers")
    orders = relationship("Order", back_populates="customer")
