# backend/app/models/store.py
from sqlalchemy import Column, String, Text, CHAR
from sqlalchemy.orm import relationship
from ..database import Base

class Store(Base):
    __tablename__ = "stores"

    id = Column(String(50), primary_key=True, index=True)
    name = Column(String(100), nullable=False)
    type = Column(String(50), nullable=False)
    address = Column(String(255))
    email = Column(String(100))
    phone = Column(String(20))
    division = Column(String(50))
    notes = Column(Text)
    category = Column(CHAR(1))

    # This defines the one-to-many relationship: One Store has many Customers.
    customers = relationship("Customer", back_populates="store")
