from pydantic import BaseModel
from typing import Optional, Dict, Any
from datetime import datetime

class OrderResponse(BaseModel):
    id: int
    customer_id: int
    status: str
    created_at: datetime
    updated_at: datetime
    cleaning_details: Optional[Dict[str, Any]] = None
    measurements: Optional[Dict[str, Any]] = None
    notes: Optional[Dict[str, Any]] = None

    class Config:
        from_attributes = True
        json_encoders = {
            datetime: lambda v: v.isoformat()
        } 