# backend/app/models/order_blanket.py
# This file should ONLY contain the OrderBlanket model.

from sqlalchemy import Column, Integer, String, Text, ForeignKey, Boolean, Numeric
from sqlalchemy.orm import relationship
from ..database import Base

class OrderBlanket(Base):
    """
    This model represents an individual blanket line item associated with a specific order.
    """
    __tablename__ = "order_blankets"

    id = Column(Integer, primary_key=True, index=True)
    order_id = Column(Integer, ForeignKey("orders.id"), nullable=False)

    # Basic Info
    type = Column(String(100))
    weight = Column(String(100))
    brand = Column(String(100), nullable=True)
    colors = Column(Text, nullable=True) # JSON string of colors
    is_plaid = Column(Boolean, default=False)
    has_pattern = Column(Boolean, default=False)
    pattern_notes = Column(Text, nullable=True)
    no_wash = Column(Boolean, default=False)
    blanket_quality_colour = Column(String(50), nullable=True)
    
    # Add-ons
    has_water_treatment = Column(Boolean, default=False)
    has_hood = Column(Boolean, default=False)
    has_heavy_soil = Column(Boolean, default=False)
    has_heavy_hair = Column(Boolean, default=False)
    has_repairs = Column(Boolean, default=False)
    is_double_weight = Column(Boolean, default=False)

    # Pricing & Notes
    base_price = Column(Numeric(10, 2), nullable=True)
    water_treatment_price = Column(Numeric(10, 2), nullable=True)
    repair_minutes = Column(Integer, nullable=True)
    repair_notes = Column(Text, nullable=True)
    notes = Column(Text, nullable=True)
    admin_notes = Column(Text, nullable=True)
    note_category = Column(String(100), nullable=True)
    
    # Special Types
    dog_type = Column(String(50), nullable=True)
    foal_mini_type = Column(String(50), nullable=True)

    # Discount & Flag
    admin_discount = Column(Text, nullable=True) # Storing as JSON string
    red_flag = Column(Boolean, default=False)
    red_flag_note = Column(Text, nullable=True)
    
    blanket_type_id = Column(Integer, nullable=True)

    # This defines the many-to-one relationship back to the Order
    order = relationship("Order", back_populates="order_blankets")
