# backend/app/models/customer.py
from sqlalchemy import Column, Integer, String, Enum, Text, ForeignKey, Boolean
from sqlalchemy.orm import relationship
from ..database import Base

class Customer(Base):
    __tablename__ = "customers"

    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(100), nullable=False)
    type = Column(Enum('barn', 'stable', 'individual'), nullable=False, default='individual')
    store_id = Column(String(50), ForeignKey("stores.id"))
    contact_name = Column(String(100))
    email = Column(String(100), unique=True, index=True)
    phone = Column(String(20))
    address = Column(String(255))
    city = Column(String(100))
    postal_code = Column(String(20))
    is_red_flagged = Column(Boolean, default=False)
    red_flag_note = Column(Text)

    orders = relationship("Order", back_populates="customer")
    
    # --- THIS IS THE NEWLY ADDED RELATIONSHIP ---
    # This tells SQLAlchemy that a Customer belongs to one Store.
    store = relationship("Store", back_populates="customers")

